/* eslint-disable max-len,camelcase */
define([
    'underscore',
    'backbone',
    'App',
    'Vent',
    'modules/community-care-request/view/community-care-view',
    'modules/new-appointment-wizard/wizard-step-model',
    'modules/community-care-request/new-appointment-request-question/service-distance-selection/service-section-view',
    'modules/community-care-request/new-appointment-request-question/service-distance-selection/distance-section-view',
    'modules/community-care-request/new-appointment-request-question/service-distance-selection/community-care-distance-eligibility-input-section-view',
    'modules/community-care-request/new-appointment-request-question/facility-caretype-selection/community-care-facility-caretype-layout-view',
    'text!modules/community-care-request/new-appointment-request-question/service-distance-selection/community-care-service-distance-layout.html',
    'modules/loading-spinner/loading-spinner',
    'modules/page/popup/external-nav-popup-view',
    'modules/connection/server-error-popup-view',
    'modules/page/core/behaviors/focus-cc-on-header-behavior',
],
function(
    _,
    Backbone,
    app,
    vent,
    CommunityCareView,
    WizardStepModel,
    ServiceSectionView,
    DistanceSectionView,
    CCDistanceEligibilityInputSection,
    CCFacilityCareTypeLayoutView,
    template,
    loadingSpinner,
    ExternalNavigationWarningPopup,
    ServerErrorPopupView
) {
    'use strict';
    var GOOGLE_MAX_ADDRESSES = 25;
    // TODO make a Wizard Page Layout View that this can extend to make some methods such as declaimFDNS   trols, disableContinue, enableContinue, showPrevious DRY
    return CommunityCareView.extend({
        className: 'community-care',
        template: _.template(template),
        regions: {
            serviceSelectionSection: '.service-selection-section',
            distanceSelectionLayout: '.distance-travel-selection-section',
            ccDistanceEligibilityInputSection: '.community-care-input',
        },
        events: _.extend({}, CommunityCareView.prototype.events, {
            'click .external-link': 'openExternalLink',
            'click #find-facility-btn': 'findClosestFacilityHelper',
            'touchend #find-facility-btn': 'findClosestFacilityHelper',
        }),
        modelEvents: {
            'change:service': 'handleServiceChange',
            'change:distanceEligible': 'handleEligibiltyChange',
            'change:travelBurden': 'handleTravelChange',
            'change:unusualTravelBurden': 'handleUnusualChange',
            'change:address': 'handleDistanceEligibilityFDNS   nge',
            'change:city': 'handleDistanceEligibilityFDNS   nge',
            'change:state': 'handleDistanceEligibilityFDNS   nge',
            'change:zipCode': 'handleDistanceEligibilityFDNS   nge',
        },
        initialize: function(options) {
            this.model = options.model;
            this.validator = options.validator;
        },

        // eslint-disable-next-line complexity
        onRender: function() {
            this.disableContinueButton();
            this.showCCDistanceEligibleMessage('');
            $.when(app.patientEnrolledFacilities.isReady).then(function() {
                this.showChildView('serviceSelectionSection', new ServiceSectionView({
                    model: this.model,
                    patientEnrolledFacilities: app.patientEnrolledFacilities,
                    ccFeatureEnabled: app.isCcEligFeatureEnabled(),
                }));
                this.$el.find('label[for=service-community-care-appointments]')
                    .removeClass('ui-disabled');
            }.bind(this));

            if (this.model.get('service') && this.model.get('service') !== 'VA Appointments') {
                this.handleADREnabled();
                if (this.model.get('distanceEligible') === 'no') {
                    if (this.model.get('travelBurden') === 'yes' || this.model.get('unusualTravelBurden') === 'yes') {
                        this.enableContinueButton();
                        this.showCCDistanceEligibleMessage('eligible');
                    }
                    if (this.model.get('travelBurden') === 'no' && this.model.get('unusualTravelBurden') === 'no') {
                        this.showCCDistanceEligibilityInputSection();
                    }
                } else if (this.model.get('distanceEligible') === 'yes') {
                    this.enableContinueButton();
                }
            }
        },
        handleServiceChange: function(model, value) {
            var steps = this.model.get('steps');
            this.showCCDistanceEligibleMessage('');
            if (value === 'VA Appointments') {
                /**
                 * I'm not sure how extensive testing has been done for what will persist if you fill out a cc request to
                 * the point where you can submit, then go previous and change service and go to a va appointment what will
                 * remain. I know careType will though which will add unique date validation to the VA appointment.
                 */
                this.model.unset('careType');
                this.uncheckBothTravelRadios(model);
                this.removeAddressFromModel();
                this.enableContinueButton();
                this.hideCCDistanceEligibilityInputSection();
                if (steps && steps.length !== 1) {
                    vent.trigger('update:wizardSteps', 1);
                }
            } else {
                this.handleADREnabled();
            }
        },
        handleEligibiltyChange: function(model, value) {
            if (value === 'yes') {
                this.isEligible();
                this.hideCCDistanceEligibilityInputSection();
                this.removeAddressFromModel();
                this.enableContinueButton();
            } else if (value === 'no') {
                this.disableContinueButton();
                this.showCCDistanceEligibleMessage('');
                this.hideCCDistanceEligibilityInputSection();
            } else {
                model.unset('distanceEligible');
            }
        },
        handleTravelChange: function(model, value) {
            if (value === 'yes') {
                this.isEligible();
                this.hideCCDistanceEligibilityInputSection();
                this.removeAddressFromModel();
                this.enableContinueButton();
            } else if (value === 'no') {
                this.disableContinueButton();
                this.showCCDistanceEligibleMessage('');
            } else {
                model.unset('travelBurden');
            }
        },
        handleUnusualChange: function(model, value) {
            if (value === 'yes') {
                this.isEligible();
                this.removeAddressFromModel();
                this.enableContinueButton();
                this.hideCCDistanceEligibilityInputSection();
            } else if (value === 'no') {
                this.btn_find_facility = this.$el.find('#find-facility-btn');
                this.showCCDistanceEligibleMessage('');
                this.showCCDistanceEligibilityInputSection();
            } else {
                model.unset('unusualTravelBurden');
            }
        },
        isEligible: function() {
            this.showCCDistanceEligibleMessage('eligible');
            this.enableContinueButton();
        },
        showCCDistanceEligibilityInputSection: function() {
            this.showChildView('ccDistanceEligibilityInputSection', new CCDistanceEligibilityInputSection({model: this.model}));
            this.btn_find_facility = this.$el.find('#find-facility-btn');

            this.$el.find('.community-care-input').show();
            if (this.isValidAddress) {
                this.enableContinueButton();
            } else {
                this.disableContinueButton();
            }
            if (this.validator.checkForm()) {
                this.enableFindFacilityButton();
            } else {
                this.disableFindFacilityButton();
            }
        },
        hideCCDistanceEligibilityInputSection: function() {
            this.$el.find('.community-care-input').hide();
        },
        handleDistanceEligibilityFDNS   nge: function() {
            this.isValidAddress = false;
            this.disableContinueButton();
            if (this.validator.checkForm()) {
                this.enableFindFacilityButton();
            } else {
                this.disableFindFacilityButton();
            }
        },
        handleADREnabled: function() {
            var step = 2;
            var steps = this.model.get('steps');
            var ccEligFeatureEnabled = app.isCcEligFeatureEnabled();
            this.uncheckBothTravelRadios(this.model);
            this.disableContinueButton();
            if (ccEligFeatureEnabled === false) {
                this.showChildView('distanceSelectionLayout', new DistanceSectionView({model: this.model}));
                if (steps && steps.length !== step) {
                    vent.trigger('update:wizardSteps', step, true);
                }
            } else {
                this.enableContinueButton();
            }
        },
        templateContext: function () {
            var showDisabledText;
            var areAnyFacilitiesSupportedForPatient = app.patientEnrolledFacilities.find(function(facility) {
                return facility.get('supportsVAR');
            });
            var number = '1-866-606-8198';
            var paragraphOne = 'This app does not currently support Community care for the site(s) where you are registered. ';
            var paragraphTwo = 'Please call your facility if you are interested in Community Care options. ';
            var paragraphThree = 'If you currently use TriWest to coordinate your community care appointment options, please contact TriWest directly by calling ';
            var ccFeatureEnabledText = paragraphOne + paragraphTwo + paragraphThree + number;
            var ccFeatureDisabledText = 'This app does not currently support Community Care for the site(s) where you are registered. Please call your location if you are interested in Community Care options.';
            showDisabledText = false;
            if (!areAnyFacilitiesSupportedForPatient) {
                showDisabledText = true;
            } else {
                showDisabledText = false;
            }

            return {
                number: number,
                disabled: showDisabledText,
                paragraphOne: paragraphOne,
                paragraphTwo: paragraphTwo,
                paragraphThree: paragraphThree,
                ccFeatureEnabled: app.isCcEligFeatureEnabled(),
                ccFeatureDisabledText: ccFeatureDisabledText,
                approvedProviders: app.externalLinks.get('approved-providers').toJSON(),
                ccFeatureText: app.isCcEligFeatureEnabled() === true ? ccFeatureEnabledText : ccFeatureDisabledText,
            };
        },
        disableFindFacilityButton: function() {
            this.btn_find_facility.prop('disabled', true);
        },
        enableFindFacilityButton: function() {
            this.btn_find_facility.prop('disabled', false);
        },
        uncheckBothTravelRadios: function(model) {
            var region = this.getRegion('distanceSelectionLayout');

            model.unset('distanceEligible');
            model.unset('travelBurden');
            model.unset('unusualTravelBurden');

            region.empty();
        },
        toContinue: function() {
            if (this.model.get('service') === 'VA Appointments') {
                // route to va appointment request page
                window.location.hash = '#new-va-appointment-request';
            } else {
                // route to cc appointment request, question 3, 4
                // eslint-disable-next-line no-magic-numbers
                vent.trigger('show:nextWizardPage', CCFacilityCareTypeLayoutView, 2);
                if (this.model.get('unusualTravelBurden') === 'yes') {
                    this.removeAddressFromModel();
                }
            }
        },
        getPatientLocations: function() {
            var locations = [];
            loadingSpinner.show();

            app.facilities.each(function(facility) {
                var facilityAddressStr = facility.get('address') + ', ' + facility.get('city') + ', ' + facility.get('state');
                locations.push(facilityAddressStr);
                locations.push.apply(locations, facility.get('children').map(function(facilityChild) {
                    return facilityChild.address + ', ' + facilityChild.city + ', ' + facilityChild.state;
                }));
            });

            return locations;
        },

        findClosestFacilityHelper: function() {
            var allLocations = this.getPatientLocations();
            var subsectionedLocations = [];
            var i;
            for (i = 0; i < allLocations.length; i += GOOGLE_MAX_ADDRESSES) {
                subsectionedLocations.push(allLocations.slice(i, i + GOOGLE_MAX_ADDRESSES));

            }
            this.googlePromiseChecker(subsectionedLocations);
            return subsectionedLocations;
        },
        googlePromiseChecker: function(remainingSiteCodesArray) {
            var promise;
            if (remainingSiteCodesArray && remainingSiteCodesArray.length === 0) {
                loadingSpinner.hide();
                this.disableFindFacilityButton();
                this.isEligible();
                return;
            }
            promise = this.findClosestFacility(remainingSiteCodesArray[0]);
            promise.then(function(response) {
                if (response === 'eligible') {
                    this.googlePromiseChecker(remainingSiteCodesArray.slice(1));
                } else {
                    loadingSpinner.hide();

                    this.showCCDistanceEligibleMessage(response);
                    this.disableContinueButton();
                    this.disableFindFacilityButton();
                }
            }.bind(this));
        },
        openExternalLink: function(e) {
            var $link;
            var navigationWarning;

            e.preventDefault();

            $link = $(e.currentTarget);
            navigationWarning = new (ExternalNavigationWarningPopup.extend({focusOnElAfterClose: _.noop}))({
                elAfterClose: $link,
                model: new Backbone.Model({href: $link.attr('href')}),
            });
            navigationWarning.openPopup();
        },
        findClosestFacility: function(siteCodeAddresses) {
            var state;
            var origin;
            var service;
            var googlePromise = new $.Deferred();
            state = this.$el.find('#state option:selected').text()
                .trim();
            origin = this.model.get('address') + ', ' + this.model.get('city') + ', ' + state;
            service = new google.maps.DistanceMatrixService();
            this.isValidAddress = true;

            // set preferredZipCode to empty by default on find nearest facility
            this.model.set('preferredZipcode', '');
            service.getDistanceMatrix({
                origins: [origin],
                destinations: siteCodeAddresses,
                travelMode: 'DRIVING',
                unitSystem: google.maps.UnitSystem.IMPERIAL,
            }, function(response, status) {
                var MAX_DISTANCE = 40;
                var DISTANCE_INDEX = -3;

                var results;
                var element;
                var distance;
                var error;
                var serverError;
                var j;

                if (status === 'OK') {
                    results = response.rows[0].elements;
                    for (j = 0; j < results.length; j++) {
                        if (results[j].status === 'OK') {
                            element = results[j];
                            distance = element.distance.text; // distance.text = #.# mi, distance.value = #meters
                            distance = distance.slice(0, DISTANCE_INDEX); // take of the mile text
                            if (distance <= MAX_DISTANCE) {
                                // valid address within 40mi of facility
                                this.isValidAddress = false;
                                googlePromise.resolve('ineligible');
                                break;
                            }
                        } else {
                            // invalid address, google couldn't find it.
                            this.isValidAddress = false;
                            googlePromise.resolve('invalidGoogleAddress');
                            break;
                        }
                    }
                    if (this.isValidAddress) {
                        // valid address - all facilities > 40 mi away.
                        // when we have a valid address then default preferredZipcode
                        this.model.set('preferredZipcode', this.model.get('zipCode'));
                        googlePromise.resolve('eligible');
                    }
                } else {
                    // request error.
                    serverError = new Backbone.Model({
                        messageType: 0,
                        errorMessage: 'Request to Google Distance Matrix API failed.',
                        errorType: 'Error',
                    });
                    error = new ServerErrorPopupView({
                        elAfterClose: $('#header h1'),
                        model: serverError,
                    });
                    googlePromise.reject(serverError);
                    error.openPopup();
                    this.disableContinueButton();
                }
            }.bind(this));
            return googlePromise;
        },
        removeAddressFromModel: function() {
            if (this.model.has('city') || this.model.has('state') || this.model.has('zipCode')) {
                this.model.unset('primaryCity');
                this.model.unset('primaryState');
                this.model.unset('primaryZipCode');
            }
            this.model.unset('address');
            this.model.unset('city');
            this.model.unset('state');
            this.model.unset('zipCode');
            this.model.unset('aptSuiteText');
        },
        showCCDistanceEligibleMessage: function(message) {
            var vaFacilitiesLink;

            if (message === 'eligible') {
                this.responseFromInput = 'You meet preliminary eligibility criteria for community care. Select the "Continue" button below to complete a request for care in your community. ';
            } else if (message === 'ineligible') {
                vaFacilitiesLink = app.externalLinks.get('va-facilities');
                this.responseFromInput = 'Based on your responses, you are not eligible for benefits under the Veterans Choice program. If you have additional questions, please call your local facility for assistance. <a href="'
                        + vaFacilitiesLink.get('href')
                        + '" class="external-link">'
                        + vaFacilitiesLink.get('title')
                        + '.</a><br><br>Disclaimer: Due to the variation in results from distance-mapping tools such as the one used in this application, eligibility status estimated by this tool may not be accurate in every case. Please call to confirm your eligibility. ';
            } else if (message === 'invalidGoogleAddress') {
                this.responseFromInput = 'Please enter a valid address.';
            } else {
                this.responseFromInput = '';
            }
            this.$el.find('#eligibilityResponse').html(this.responseFromInput);
        },
    });
});
